/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.rank.Rank;

public record LootItemChampionPropertyCondition(LootContext.EntityTarget target, MinMaxBounds.Ints tier, AffixesPredicate affixes) implements LootItemCondition
{
    public static final LootItemConditionType INSTANCE = new LootItemConditionType((Serializer)new ChampionConditionSerializer());

    @Nonnull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)this.target.m_79003_());
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.m_78953_(this.target.m_79003_());
        return ChampionCapability.getCapability(entity).map(champion -> {
            IChampion.Server server = champion.getServer();
            int tier = server.getRank().map(Rank::getTier).orElse(0);
            if (tier <= 0 || !this.tier.m_55390_(tier)) {
                return false;
            }
            List<IAffix> affixes = server.getAffixes();
            return this.affixes.matches(affixes);
        }).orElse(false);
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return INSTANCE;
    }

    private record AffixesPredicate(Set<String> values, MinMaxBounds.Ints matches, MinMaxBounds.Ints count) {
        private static final AffixesPredicate ANY = new AffixesPredicate(new HashSet<String>(), MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_);

        private boolean matches(List<IAffix> input) {
            if (this.values.isEmpty()) {
                return this.count.m_55390_(input.size());
            }
            Set affixes = input.stream().map(IAffix::getIdentifier).collect(Collectors.toSet());
            int found = 0;
            for (String affix : this.values) {
                if (!affixes.contains(affix)) continue;
                ++found;
            }
            return this.matches.m_55390_(found) && this.count.m_55390_(input.size());
        }

        private static AffixesPredicate fromJson(JsonElement json) {
            if (json != null && !json.isJsonNull()) {
                if (json.isJsonArray()) {
                    JsonArray jsonArray = GsonHelper.m_13924_((JsonElement)json, (String)"affixes");
                    HashSet<String> affixes = new HashSet<String>();
                    for (JsonElement jsonElement : jsonArray) {
                        if (!jsonElement.isJsonPrimitive()) continue;
                        affixes.add(jsonElement.getAsString());
                    }
                    return new AffixesPredicate(affixes, MinMaxBounds.Ints.m_55386_((int)1), MinMaxBounds.Ints.f_55364_);
                }
                JsonObject jsonObject = json.getAsJsonObject();
                HashSet<String> affixes = new HashSet<String>();
                if (jsonObject.has("values")) {
                    JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"values");
                    for (JsonElement jsonElement : jsonArray) {
                        if (!jsonElement.isJsonPrimitive()) continue;
                        affixes.add(jsonElement.getAsString());
                    }
                }
                MinMaxBounds.Ints matches = MinMaxBounds.Ints.m_55386_((int)1);
                if (jsonObject.has("matches")) {
                    matches = MinMaxBounds.Ints.m_55373_((JsonElement)jsonObject.get("matches"));
                }
                MinMaxBounds.Ints count = MinMaxBounds.Ints.f_55364_;
                if (jsonObject.has("count")) {
                    count = MinMaxBounds.Ints.m_55373_((JsonElement)jsonObject.get("count"));
                }
                return new AffixesPredicate(affixes, matches, count);
            }
            return ANY;
        }

        public JsonElement serializeToJson() {
            if (this.values.isEmpty() && this.count.m_55327_() && this.matches.m_55327_()) {
                return JsonNull.INSTANCE;
            }
            JsonObject jsonObject = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            for (String value : this.values) {
                jsonArray.add(value);
            }
            Integer min = (Integer)this.count.m_55305_();
            Integer max = (Integer)this.count.m_55326_();
            if (min != null && min == 1 && max == null) {
                return jsonArray;
            }
            jsonObject.add("values", (JsonElement)jsonArray);
            jsonObject.add("matches", this.matches.m_55328_());
            jsonObject.add("count", this.count.m_55328_());
            return jsonObject;
        }
    }

    public static class ChampionConditionSerializer
    implements Serializer<LootItemChampionPropertyCondition> {
        public void serialize(JsonObject json, LootItemChampionPropertyCondition value, JsonSerializationContext context) {
            json.add("tier", value.tier.m_55328_());
            json.add("affixes", value.affixes.serializeToJson());
            json.add("entity", context.serialize((Object)value.target));
        }

        @Nonnull
        public LootItemChampionPropertyCondition deserialize(JsonObject json, @Nonnull JsonDeserializationContext context) {
            MinMaxBounds.Ints tier = MinMaxBounds.Ints.m_55373_((JsonElement)json.get("tier"));
            AffixesPredicate affixes = AffixesPredicate.fromJson(json.get("affixes"));
            return new LootItemChampionPropertyCondition((LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class), tier, affixes);
        }
    }
}

